/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

/**
 * \file    ioexpander.h
 *
 * \brief   IO Expander Header File
 *
 * This header file contains the Macros definitions for GPIO expander
 * 
 *
 * \author  0043
 *
 * \version 01a,25aug,2010 Created.
 */

#ifndef _DM814x_ioexpander_H_
#define _DM814x_ioexpander_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_i2c.h"

/**
@addtogroup DM814x EVM GPIO Expander
@{
*/

/*
 *====================
 * Defines
 *====================
 */ 
#define GPIO_EXP_I2C_BUS_NUM	0x0
#define GPIO_EXP_SLAVE_ADDR		0x20

/*
 *====================
 * Function declaration
 *====================
*/
STATUS i2c0IoExpStatusGet
( 
    UINT8 u8I2cBusNum, 
    UINT8 u8SlaveAddr, 
    UINT16* pu16Val 
);  
STATUS i2cIoExpInit 
(
    UINT8 u8I2cBusNum, 
    UINT8 u8SlaveAddr
);
STATUS i2c0IoExpStatusBitSet
(
    UINT8 u8I2cBusNum,
    UINT8 u8SlaveAddr,
    UINT8 u8Index, 
    UINT8 u8State
);
/* @} */   /* End of DM814x EVM GPIO Expander */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM814x_EVM_H_ */
